/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.curios;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.model.BackpackLayerModel;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackLayer;
import com.tiviacz.travelersbackpack.compat.curios.AccessoriesPatch;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

public class TravelersBackpackCurio
implements ICurio {
    public final ItemStack stack;

    public TravelersBackpackCurio(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack) {
        if (!((Boolean)TravelersBackpackConfig.COMMON.backpackSettings.curiosIntegration.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.f_36096_ instanceof TravelersBackpackItemMenu) {
                return;
            }
            if (!player.m_9236_().f_46443_) {
                CapabilityUtils.getCapability(player).ifPresent(data -> {
                    data.setWearable(this.stack);
                    data.setContents(this.stack);
                    data.synchronise();
                    data.synchroniseToOthers(player);
                });
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return false;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack) {
        if (!((Boolean)TravelersBackpackConfig.COMMON.backpackSettings.curiosIntegration.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.f_36096_ instanceof TravelersBackpackItemMenu) {
                return;
            }
            if (!player.m_9236_().f_46443_) {
                CapabilityUtils.getCapability(player).ifPresent(data -> {
                    data.removeWearable();
                    data.synchronise();
                    data.synchroniseToOthers(player);
                });
            }
        }
    }

    public void curioTick(SlotContext slotContext) {
        if (!((Boolean)TravelersBackpackConfig.COMMON.backpackSettings.curiosIntegration.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.f_36096_ instanceof TravelersBackpackItemMenu || !CapabilityUtils.isWearingBackpack(player)) {
                return;
            }
            if (player.f_36096_ instanceof CuriosContainer) {
                return;
            }
            if (TravelersBackpack.accessoriesLoaded && AccessoriesPatch.isAccessoriesMenuOpened(player)) {
                return;
            }
            ItemStack backpack = CapabilityUtils.getWearingBackpack(player);
            if (!ItemStack.m_150942_((ItemStack)backpack, (ItemStack)this.getStack())) {
                this.getStack().m_41751_(backpack.m_41783_());
            }
        }
    }

    public boolean canEquip(SlotContext slotContext) {
        return (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.curiosIntegration.get();
    }

    @Nonnull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit) {
        return ICurio.DropRule.DEFAULT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerCurioRenderer() {
        ModItems.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackItem).forEach(holder -> CuriosRendererRegistry.register((Item)((Item)holder.get()), Renderer::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Renderer
    implements ICurioRenderer {
        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack itemStack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int i, float v, float v1, float v2, float v3, float v4, float v5) {
            LivingEntity livingEntity = slotContext.entity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                livingEntity = renderLayerParent.m_7200_();
                if (livingEntity instanceof HumanoidModel) {
                    HumanoidModel humanoidModel = (HumanoidModel)livingEntity;
                    BackpackLayerModel<?> backpackLayerModel = BackpackLayerModel.LAYER_MODEL;
                    backpackLayerModel.setBackpackStack(itemStack);
                    TravelersBackpackLayer.renderBackpackLayer(backpackLayerModel, humanoidModel, poseStack, multiBufferSource, i, (LivingEntity)player, itemStack, v, v1, v2, v3, v4, v5);
                }
            }
        }
    }
}

